<?php

$elements = [
    'content-elements'  => [
        'title' => __( 'Content Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'creative-btn',
                'title' => __( 'Creative Button', 'essential-addons-elementor' ),
            ],
            [
                'key'   => 'team-members',
                'title' => __( 'Team Member', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'testimonials',
                'title' => __( 'Testimonial', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'flip-box',
                'title' => __( 'Flip Box', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'info-box',
                'title' => __( 'Info Box', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'dual-header',
                'title' => __( 'Dual Color Heading', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'tooltip',
                'title' => __( 'Tooltip', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'adv-accordion',
                'title' => __( 'Advanced Accordion', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'adv-tabs',
                'title' => __( 'Advanced Tabs', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'feature-list',
                'title' => __( 'Feature List', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'offcanvas',
                'title'  => __( 'Offcanvas', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'advanced-menu',
                'title'  => __( 'Advanced Menu', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'toggle',
                'title'  => __( 'Toggle', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'testimonial-slider',
                'title'  => __( 'Testimonial Slider', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'static-product',
                'title'  => __( 'Static Product', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'team-member-carousel',
                'title'  => __( 'Team Member Carousel', 'essential-addons-elementor' ),
                'is_pro' => true
            ]
        ]
    ],
    'dynamic-content-elements'  => [
        'title' => __( 'Dynamic Content Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'post-grid',
                'title' => __( 'Post Grid', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'post-timeline',
                'title' => __( 'Post Timeline', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'data-table',
                'title' => __( 'Data Table', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'content-ticker',
                'title' => __( 'Content Ticker', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'product-grid',
                'title'  => __( 'Product Grid', 'essential-addons-elementor' ),
            ],
            [
                'key'   => 'adv-google-map',
                'title' => __( 'Advanced Google Map', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'post-block',
                'title'  => __( 'Post Block', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'post-carousel',
                'title'  => __( 'Post Carousel', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'post-list',
                'title'  => __( 'Smart Post List', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'woo-collections',
                'title'  => __( 'Woo Product Collections', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'content-timeline',
                'title'  => __( 'Content Timeline', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'dynamic-filter-gallery',
                'title'  => __( 'Dynamic Gallery', 'essential-addons-elementor' ),
                'is_pro' => true
            ]
        ]
    ],
    'creative-elements' => [
        'title' => __( 'Creative Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'count-down',
                'title' => __( 'Count Down', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'fancy-text',
                'title' => __( 'Fancy Text', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'filter-gallery',
                'title' => __( 'Filterable Gallery', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'image-accordion',
                'title'  => __( 'Image Accordion', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'progress-bar',
                'title' => __( 'Progress Bar', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'interactive-promo',
                'title'  => __( 'Interactive Promo', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'counter',
                'title'  => __( 'Counter', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'lightbox',
                'title'  => __( 'Lightbox & Modal', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'protected-content',
                'title'  => __( 'Protected Content', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'img-comparison',
                'title'  => __( 'Image Comparison', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'flip-carousel',
                'title'  => __( 'Flip Carousel', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'logo-carousel',
                'title'  => __( 'Logo Carousel', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'interactive-cards',
                'title'  => __( 'Interactive Cards', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'one-page-navigation',
                'title'  => __( 'One Page Navigation', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'image-hotspots',
                'title'  => __( 'Image Hotspots', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'divider',
                'title'  => __( 'Divider', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'image-scroller',
                'title'  => __( 'Image Scroller', 'essential-addons-elementor' ),
                'is_pro' => true
            ]
        ]
    ],
    'marketing-elements'    => [
        'title' => __( 'Marketing Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'call-to-action',
                'title' => __( 'Call To Action', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'price-table',
                'title' => __( 'Pricing Table', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'price-menu',
                'title'  => __( 'Price menu', 'essential-addons-elementor' ),
                'is_pro' => true
            ]
        ]
    ],
    'form-styler-elements'  => [
        'title' => __( 'Form Styler Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'contact-form-7',
                'title' => __( 'Contact Form 7', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'weforms',
                'title' => __( 'weForms', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'ninja-form',
                'title' => __( 'Ninja Form', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'gravity-form',
                'title' => __( 'Gravity Form', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'caldera-form',
                'title' => __( 'Caldera Form', 'essential-addons-elementor' )
            ],
            [
                'key'   => 'wpforms',
                'title' => __( 'WPForms', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'mailchimp',
                'title'  => __( 'Mailchimp', 'essential-addons-elementor' ),
                'is_pro' => true
            ]
        ]
    ],
    'social-feed-elements'  => [
        'title' => __( 'Social Feed Elemens', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'twitter-feed',
                'title' => __( 'Twitter Feed', 'essential-addons-elementor' )
            ],
            [
                'key'    => 'twitter-feed-carousel',
                'title'  => __( 'Twitter Feed Carousel', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
            [
                'key'    => 'instagram-gallery',
                'title'  => __( 'Instagram Feed', 'essential-addons-elementor' ),
                'is_pro' => true
            ],
        ]
    ]
];

$elements = apply_filters( 'add_eael_elementor_addons', $elements );

?>
<div id="elements" class="eael-settings-tab eael-elements-list">
    <div class="row">
        <div class="col-full">
            <div class="elements-global-control-wrap">
                <h4><?php _e('Global Control') ?></h4>
                <p><?php _e('Use the Buttons to Activate or Deactivate all the Elements of Essential Addons at once.') ?></p>

                <div class="eael-btn-group">
                    <button type="button" class="eael-btn eael-global-control-enable"><?php _e('Enable All') ?></button>
                    <button type="button" class="eael-btn eael-global-control-disable"><?php _e('Disable All') ?></button>
                </div>
            </div>
            <?php foreach($elements as $element) : ?>
                <?php echo !empty($element['title']) ? '<h4>'.$element['title'].'</h4>' : ''; ?>

                <div class="eael-checkbox-container">
                    <?php
                        foreach($element['elements'] as $item) {
                            $status = isset($item['is_pro']) && !$this->pro_enabled ? 'disabled' : checked( 1, $this->get_settings($item['key']), false );
                            $label_class = isset($item['is_pro']) && !$this->pro_enabled ? 'eael-get-pro' : '';
                            $class = isset($item['class']) ? ' '.$item['class'] : '';
                        ?>
                        <div class="eael-checkbox<?php echo $class; ?>">
                            <input type="checkbox" id="<?php echo esc_attr($item['key']); ?>" name="<?php echo esc_attr($item['key']); ?>" <?php echo $status; ?>>
                            <label for="<?php echo esc_attr($item['key']); ?>" class="<?php echo $label_class; ?>"></label>
                            <p class="eael-el-title">
                                <?php _e( $item['title'], 'essential-addons-elementor' ) ?>
                                <?php echo isset( $item['is_pro'] ) && !$this->pro_enabled ? '<sup class="pro-label">Pro</sup>' : ''; ?>
                                <?php
                                    if ($item['key'] === 'mailchimp' && $this->pro_enabled) {
                                        echo '
                                        <span style="font-size: 12px; font-style:italic;"><a href="#" class="eael-admin-settings-popup" data-settings="mailchimp-api" data-title="Mailchimp API Key" data-key="eael_mailchimp_api">'.__('Settings', 'essential-addons-elementor').'</a></span>
                                        <input type="hidden" name="mailchimp-api" id="mailchimp-api-hidden" class="mailchimp-api" placeholder="Set API Key" value="'.get_option('eael_save_mailchimp_api').'">';
                                    } elseif($item['key'] === 'adv-google-map' && $this->pro_enabled) {
                                        echo '<span style="font-size: 12px; font-style:italic;"><a href="#" class="eael-admin-settings-popup" data-settings="google-map-api" data-title="Google Map API Key" data-key="eael_google_map_api">'.__('Settings', 'essential-addons-elementor').'</a></span>
                                        <input type="hidden" name="google-map-api" id="google-map-api-hidden" class="google-map-api" placeholder="Set API Key" value="'.get_option('eael_save_google_map_api').'">';
                                    }
                                ?>
                            </p>
                        </div>
                    <?php } ?>
                </div>
            <?php endforeach; ?>

            <div class="eael-save-btn-wrap">
                <button type="submit" class="button eael-btn js-eael-settings-save"><?php _e('Save settings', 'essential-addons-elementor'); ?></button>
            </div>
        </div>
    </div>
</div>